package cn.itcast.message;

import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Data
public abstract class Message implements Serializable {

    /**
     * 根据消息类型字节，获得对应的消息 class
     * @param messageType 消息类型字节
     * @return 消息 class
     */
    public static Class<? extends Message> getMessageClass(int messageType) {
        return messageClasses.get(messageType);
    }

    private int sequenceId;

    private int messageType;

    /**
     * 获取消息类型
     *
     * @return 消息的类型
     */
    public abstract int getMessageType();

    /**
     * 登陆请求
     */
    public static final int LoginRequestMessage = 0;
    /**
     * 登陆响应
     */
    public static final int LoginResponseMessage = 1;
    /**
     * 聊天请求
     */
    public static final int ChatRequestMessage = 2;
    /**
     * 聊天响应
     */
    public static final int ChatResponseMessage = 3;
    /**
     * 组创建请求
     */
    public static final int GroupCreateRequestMessage = 4;
    /**
     * 组创建响应
     */
    public static final int GroupCreateResponseMessage = 5;
    /**
     * 组加入请求
     */
    public static final int GroupJoinRequestMessage = 6;
    /**
     * 组加入响应
     */
    public static final int GroupJoinResponseMessage = 7;
    /**
     * 组退出请求
     */
    public static final int GroupQuitRequestMessage = 8;
    /**
     * 组退出响应
     */
    public static final int GroupQuitResponseMessage = 9;
    /**
     * 组聊天请求
     */
    public static final int GroupChatRequestMessage = 10;
    /**
     * 组聊天响应
     */
    public static final int GroupChatResponseMessage = 11;
    /**
     * 组成员信息请求
     */
    public static final int GroupMembersRequestMessage = 12;
    /**
     * 组成员信息响应
     */
    public static final int GroupMembersResponseMessage = 13;
    /**
     * 连接ping请求
     */
    public static final int PingMessage = 14;
    /**
     * 连接pong响应
     */
    public static final int PongMessage = 15;
    /**
     * 请求类型 byte 值
     */
    public static final int RPC_MESSAGE_TYPE_REQUEST = 101;
    /**
     * 响应类型 byte 值
     */
    public static final int  RPC_MESSAGE_TYPE_RESPONSE = 102;

    /**
     * 消息事件集合
     */
    private static final Map<Integer, Class<? extends Message>> messageClasses = new HashMap<>();

    static {
        messageClasses.put(LoginRequestMessage, LoginRequestMessage.class);
        messageClasses.put(LoginResponseMessage, LoginResponseMessage.class);
        messageClasses.put(ChatRequestMessage, ChatRequestMessage.class);
        messageClasses.put(ChatResponseMessage, ChatResponseMessage.class);
        messageClasses.put(GroupCreateRequestMessage, GroupCreateRequestMessage.class);
        messageClasses.put(GroupCreateResponseMessage, GroupCreateResponseMessage.class);
        messageClasses.put(GroupJoinRequestMessage, GroupJoinRequestMessage.class);
        messageClasses.put(GroupJoinResponseMessage, GroupJoinResponseMessage.class);
        messageClasses.put(GroupQuitRequestMessage, GroupQuitRequestMessage.class);
        messageClasses.put(GroupQuitResponseMessage, GroupQuitResponseMessage.class);
        messageClasses.put(GroupChatRequestMessage, GroupChatRequestMessage.class);
        messageClasses.put(GroupChatResponseMessage, GroupChatResponseMessage.class);
        messageClasses.put(GroupMembersRequestMessage, GroupMembersRequestMessage.class);
        messageClasses.put(GroupMembersResponseMessage, GroupMembersResponseMessage.class);
        messageClasses.put(RPC_MESSAGE_TYPE_REQUEST, RpcRequestMessage.class);
        messageClasses.put(RPC_MESSAGE_TYPE_RESPONSE, RpcResponseMessage.class);
    }

}
