// 定义组件
const lyTop = {
  template: `
    <div class='nav-top' @click="show=false"> 
     <shortcut/>
        <!--头部--> 
      <div class='header' id='headApp'> 
            <div class='py-container'> 
                <div class='yui3-g Logo'> 
                    <div class='yui3-u Left logoArea'> 
                        <a class='logo-bd' title='乐优' href='/index.html' target='_blank'></a> 
                    </div> 
                    <div class='yui3-u Center searchArea'> 
                        <div class='search'> 
                            <div class='sui-form form-inline'> 
                                <!--searchAutoComplete--> 
                                <div class='input-append'> 
                                    <input type='text' v-model='key' @click.stop="" @focus="show=true" 
                                           @keyup="handleKeyup($event)"  class='input-error input-xxlarge' /> 
                                    <button @click='search' class='sui-btn btn-xlarge btn-danger' type='button'>搜索</button> 
                                </div>
                              <div v-show="options.length > 0 && show"
                                  style="position: relative; border: 1px solid #ccc; background: #fff;box-shadow: 1px 3px 2px rgba(0,0,0,.2);z-index: 999;">
                                <ul style="list-style-type: none;">
                                  <li v-for="(o, i) in options" :key="i" @mouseenter="index=i" @click="search"
                                      :style='{"background-color": index===i ? "#EEE" : "#fff"}'>{{o}}</li>
                                </ul>
                              </div>
                            </div>
                            
                        </div> 
                        <div class='hotwords'> 
                            <ul> 
                                <li class='f-item'>乐优首发</li> 
                                <li class='f-item'>亿元优惠</li> 
                                <li class='f-item'>9.9元团购</li> 
                                <li class='f-item'>每满99减30</li> 
                                <li class='f-item'>亿元优惠</li> 
                                <li class='f-item'>9.9元团购</li> 
                                <li class='f-item'>办公用品</li> 
                            </ul> 
                        </div> 
                    </div> 
                    <div class='yui3-u Right shopArea'> 
                        <div class='fr shopcar'> 
                            <div class='show-shopcar' id='shopcar'> 
                                <span class='car'></span> 
                                <a class='sui-btn btn-default btn-xlarge' href='/cart.html' target='_blank'> 
                                    <span>我的购物车</span> 
                                    <i class='shopnum'>0</i> 
                                </a> 
                                <div class='clearfix shopcarlist' id='shopcarlist' style='display:none'> 
                                    <p>'啊哦，你的购物车还没有商品哦！'</p> 
                                    <p>'啊哦，你的购物车还没有商品哦！'</p> 
                                </div> 
                            </div> 
                        </div> 
                    </div> 
                </div> 
                <div class='yui3-g NavList'> 
                    <div class='yui3-u Left all-sort'> 
                        <h4>乐优精品</h4> 
                    </div> 
                    <div class='yui3-u Center navArea'> 
                        <ul class='nav'> 
                            <li class='f-item'>服装城</li> 
                            <li class='f-item'>美妆馆</li> 
                            <li class='f-item'>品优超市</li> 
                            <li class='f-item'>全球购</li> 
                            <li class='f-item'>闪购</li> 
                            <li class='f-item'>团购</li> 
                            <li class='f-item'>有趣</li> 
                            <li class='f-item'><a href='/seckill-index.html' target='_blank'>秒杀</a></li> 
                        </ul> 
                    </div> 
                    <div class='yui3-u Right'></div> 
                </div> 
            </div> 
        </div>
    </div> 
      `,
  name:'ly-top',
  data() {
    return {
      key: "",
      query: location.search,
      options: [], // 自动补全的待选项
      index: -1, // 鼠标悬停的选项的角标
      show: false
    }
  },
  watch: { // 监控data中的属性的变化，方法名，就是要监控的属性的名称
    index(){
      if(this.index !== -1){
        this.key = this.options[this.index]
      }
    }
  },
  methods: {
    handleKeyup(e){
      console.log(e.key, e.keyCode);
      if((e.keyCode >= 48 && e.keyCode <= 57) || (e.keyCode >= 65 && e.keyCode <= 90) || e.keyCode === 8){
        // 用户输入的字符，需要自动补全
        this.getSuggestion();
      }else if(e.keyCode === 13){
        // 用户按回车，需要搜索
        this.search();
      }else if(e.keyCode === 38){
        if(this.index > 0){
          this.index--;
        }
      }else if(e.keyCode === 40){
        if(this.index >= this.options.length){
          this.index = 0;
        }else{
          this.index++;
        }
      }else if(e.keyCode === 27){
        this.show =false
      }
    },
    getSuggestion(){ // 查询自动补全
      if(!this.key){
        // key没有值，不去搜索了
        this.options = [];
        return;
      }
      axios.get("/search/goods/suggestion?key=" + this.key)
        .then(resp => {
          this.options = resp.data;
        })
        .catch(e => {
          this.options = []
          console.log(e);
        })
    },
    search() {
      window.location = '/search.html?key=' + this.key;
    },
    getUrlParam: function (name) {
      var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)", "i");
      var r = window.location.search.substr(1).match(reg);
      if (r != null) {
        return decodeURI(r[2]);
      }
      return null;
    }
  },
  created() {
    this.key = this.getUrlParam("key");
  }
}
// 注册组件
Vue.component("lyTop", lyTop);